[CmdletBinding()]
param(
	# Array of module names validate the configuration. If no module names given, configuration of all modules is validated.
	[Parameter(Mandatory = $false)]
	[array]$moduleNames
)

$ErrorActionPreference = "Stop"

$assetsFolder = Join-Path $PSScriptRoot "Assets"
$configurationPath = Join-Path $PSScriptRoot "Configuration"
$deliveryProcessToolingPath = Join-Path $assetsFolder "DeliveryProcess.Tooling"
$generateConfiguration= Join-Path $deliveryProcessToolingPath "Generate-Configuration.ps1"

if ($moduleNames) {
	$moduleFolders = Get-ChildItem "$assetsFolder/Modules" -Directory | Where-Object Name -In $moduleNames
} else {
	$moduleFolders = Get-ChildItem "$assetsFolder/Modules" -Directory
}

foreach ($moduleFolder in $moduleFolders) {
	$templateFolders = Get-ChildItem $moduleFolder.FullName -Directory | Where-Object { $_.Name -like "ConfigurationTemplates-*"}
	foreach ($templateFolderPath in $templateFolders) {
		$componentName = $templateFolderPath.Name.Split("-")[1];
		$output = Join-Path $moduleFolder.FullName "TransformedConfiguration/$componentName"
		& $generateConfiguration -values $configurationPath -templates $templateFolderPath.FullName -componentName $componentName -output $output -failIfNoMatch
	}
}

Write-Host "Configuration is valid."
