[CmdletBinding()]
param(
)

$ErrorActionPreference = "Stop"

if ((& (Join-Path $PSScriptRoot './Test-IsAdmin.ps1')) -ne $true) {
    Write-Error "Access denied. You must run this script with elevated permissions."
}

Write-Host "Installing host stats exporter."

if ($IsLinux) {
    # Copy the binary - that's pretty much all we need.
    $binarySourcePath = Join-Path $PSScriptRoot "node_exporter"
    $appPath = "/node_exporter"

    if (Test-Path $appPath) {
        Write-Host "Deleting existing installation."

        # Does not matter if if tails, just keep going.
        & systemctl stop node_exporter

        Remove-Item $appPath -Recurse -Force
    }

    New-Item -ItemType Directory -Path /node_exporter | Out-Null
    Copy-Item $binarySourcePath -Destination /node_exporter | Out-Null

    & chmod +x /node_exporter/node_exporter

    # And register it on startup.
    Set-Content -Path "/etc/systemd/system/node_exporter.service" -Value @"
[Unit]
Description=Server metrics exporter (Prometheus)

[Service]
User=root
Restart=always
ExecStart=/node_exporter/node_exporter

[Install]
WantedBy=multi-user.target
"@

    # And enable it to start next boot.
    & systemctl daemon-reload

    if ($LASTEXITCODE -ne 0) {
        Write-Error "Failed to install the service!"
    }

    & systemctl enable node_exporter

    if ($LASTEXITCODE -ne 0) {
        Write-Error "Failed to install the service!"
    }

    & systemctl start node_exporter

    if ($LASTEXITCODE -ne 0) {
        Write-Error "Failed to install the service!"
    }

    # And allow in firewall.
    ufw allow 9100

    if ((ufw status) -ne "Status: inactive") {
        ufw reload
    }

    Write-Host "Host stats exporter installed on port 9100."
}
else {
    $installerPath = Join-Path $PSScriptRoot "wmi_exporter.msi"

    # This automatically configures firewall.
    & msiexec /passive /i $installerPath ENABLED_COLLECTORS="cpu,cs,logical_disk,net,os,system"

    Write-Host "Host stats exporter installed on port 9182."
}