[CmdletBinding()]
param(
    # Version/tag of the image to install. Defaults to latest.
    [Parameter(Mandatory = $false)]
    [string]$version = "latest",

    [Parameter()]
    [switch]$useLocalImage
)

$ErrorActionPreference = "Stop"

$myDirectoryPath = $PSScriptRoot

if (!$myDirectoryPath) {
    $myDirectoryPath = "."
}

. (Join-Path $myDirectoryPath "./Functions.ps1")

$serviceInstallScriptPath = Join-Path $myDirectoryPath "Install-InfrastructureService.ps1"

$componentName = "dashboard"

if ($IsLinux) {
    & $serviceInstallScriptPath -containerName $componentName -imageNamespace "sms" -imageName "$componentName-linux" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume /ComponentHost/Infrastructure/Config/$componentName/:/Config/ --volume /ComponentHost/Infrastructure/Logs/$componentName/:/Logs/ --ip 172.31.250.203 --publish 6810:80"  -useLocalImage:$useLocalImage
}
else {
    & $serviceInstallScriptPath -containerName "$componentName" -imageNamespace "sms" -imageName "$componentName-windows$(GetWindowsVersion)" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume C:\ComponentHost\Infrastructure\Config\$componentName\:C:\Config\ --volume C:\ComponentHost\Infrastructure\Logs\$componentName\:C:\Logs\ --ip 172.31.250.203 --publish 6810:80" -useLocalImage:$useLocalImage
}

if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to install the service!"
}

Write-Host "Success."