# PowerShell has no native mechanism to write UTF-8 files without BOM, but .NET has, so this method
# essentially wraps the .NET method that does it. Useful when creating configuration files for third party
# applications that fail to parse files with BOMs.
function Out-FileWithoutBOM($fileName)
{
	foreach ($content in $input) {
        # Create the file if it doesn't exist because even though WriteAllText function would create the file,
        # we need to use Resolve-Path which works only on existing files.
		if (!(Test-Path $fileName)) {
			New-Item $fileName -ItemType File | Out-Null
		}
	
		[IO.File]::WriteAllText(($fileName | Resolve-Path), $content)
		
		# Ignore other piped in content strings in case there were multiple.
		return
	}
}

function Get-DockerDaemonConfigFolder {
    if ($IsLinux) {
        return "/etc/docker/"
    } else {
        return Join-Path $env:ProgramData "docker\config"
    }
}