# Returns the suffix (2016, 1803 or similar)
function GetWindowsVersion() {
    if ([Environment]::OSVersion.Version -eq "10.0.14393.0") {
        # Windows 2016 (or old Windows 10).
        return "2016"
    }
    elseif ([Environment]::OSVersion.Version -eq "10.0.17134.0") {
        # Windows 1803 (or modern Windows 10).
        return "1803"
    }
    else {
        Write-Error "Unsupported Windows version: $([Environment]::OSVersion.Version)"
        return $null
    }
}