[CmdletBinding()]
param (
# The list of components in the module (the same list returned by Module.ps1).
# In the future, this might include extra properties that inform about performed install actions.
    [Parameter(Mandatory = $true)]
    [object]$components,

# Root of the transformed configuration directory.
# Each subdirectory is named after the AssetKey of the component it is for.
    [Parameter(Mandatory = $true)]
    [string]$transformedConfigurationPath,

# Absolute path to DeliveryProcess.Tooling package root.
    [Parameter(Mandatory = $true)]
    [string]$toolingPath
)

# Create rabbitmq data folders.
mkdir -p /ComponentHost/CustomComponents/Data/rabbitmq
mkdir -p /ComponentHost/CustomComponents/Data/postgres
mkdir -p /ComponentHost/CustomComponents/Logs/rabbitmq

# Run RabbitMQ server.
$rabbitMq = $components | ? { $_.Image.Name -eq "rabbitmq" }
& docker rm -f rabbitmq
& docker run -d -h vip-rabbitmq -v /ComponentHost/CustomComponents/Data/rabbitmq:/var/lib/rabbitmq -v /ComponentHost/CustomComponents/Logs/rabbitmq:/var/log/rabbitmq --name rabbitmq --restart always --ip 172.31.250.101 --network axinom rabbitmq:$($rabbitMq.Image.Version)

# Wait a little for RabbitMQ server to start.
Write-Host "Waiting 15 seconds for RabbitMQ server to start, before declaring base queues & exchanges..."
Start-Sleep -s 15

# Declare initial stuff inside rabbitmq.
& docker exec -it rabbitmq rabbitmqadmin declare exchange name=cancellation type=fanout durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin declare queue name=acquire durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin declare queue name=encode durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin declare queue name=publish durable=true auto_delete=false

# Run PostgreSQL server.
$postgres = $components | ? { $_.Image.Name -eq "postgres" }
& docker rm -f postgres
& docker run -d -h vip-postgres -v /ComponentHost/CustomComponents/Data/postgres:/var/lib/postgresql/data --name postgres --restart always --ip 172.31.250.102 --network axinom postgres:$($postgres.Image.Version)
