[CmdletBinding()]

$ErrorActionPreference = "Stop"

$assetsFolder = Join-Path $PSScriptRoot "Assets"
$configurationPath = Join-Path $PSScriptRoot "Configuration"
$deliveryProcessToolingPath = Join-Path $assetsFolder "DeliveryProcess.Tooling"
$generateConfiguration= Join-Path $deliveryProcessToolingPath "Generate-Configuration.ps1"

$allTemplateFolders = Get-ChildItem "$assetsFolder/Modules" -Recurse -Directory | Where-Object { $_.name -like "ConfigurationTemplates-*"}

foreach ($templateFolderPath in $allTemplateFolders) {
	$componentName = $templateFolderPath.Name.Split("-")[1];
	$moduleFolder = Split-Path $templateFolderPath.FullName
	$output = Join-Path $moduleFolder "TransformedConfiguration/$componentName"
	& $generateConfiguration -values $configurationPath -templates $templateFolderPath.FullName -componentName $componentName -output $output -failIfNoMatch
}

Write-Host "Configuration is valid."
