[CmdletBinding()]
param(
    # Must be either "latest" or "cb".
    [Parameter()]
    [string]$version = "latest",

    # If provided, images will not be pulled (expects the images to already exist locally).
    [Parameter()]
    [switch]$useLocalImages
)

$ErrorActionPreference = "Stop"

if (@("cb", "latest") -notcontains $version) {
    Write-Error "Version argument must be either 'cb' or 'latest'"
    return
}

& (Join-Path $PSScriptRoot Install-InfrastructureConfiguration.ps1)
& (Join-Path $PSScriptRoot Install-HttpGateway.ps1) -version $version -useLocalImage:$useLocalImages
& (Join-Path $PSScriptRoot Install-DeploymentAgent.ps1) -version $version -useLocalImage:$useLocalImages
& (Join-Path $PSScriptRoot Install-DockerStatsExporter.ps1) -version $version -useLocalImage:$useLocalImages
& (Join-Path $PSScriptRoot Install-Dashboard.ps1) -version $version -useLocalImage:$useLocalImages
& (Join-Path $PSScriptRoot Install-DockerMaintenanceService.ps1) -version $version -useLocalImage:$useLocalImages
& (Join-Path $PSScriptRoot Install-HostStatsExporter.ps1)