[CmdletBinding()]
param (
# The list of components in the module (the same list returned by Module.ps1).
# In the future, this might include extra properties that inform about performed install actions.
    [Parameter(Mandatory = $true)]
    [object]$components,

# Root of the transformed configuration directory.
# Each subdirectory is named after the AssetKey of the component it is for.
    [Parameter(Mandatory = $true)]
    [string]$transformedConfigurationPath,

# Absolute path to DeliveryProcess.Tooling package root.
    [Parameter(Mandatory = $true)]
    [string]$toolingPath
)

# Run RabbitMQ server.
$rabbitMq = $components | ? { $_.Image.Name -eq "rabbitmq" }
& docker rm -f rabbitmq
& docker run -d --name rabbitmq --restart always --network axinom rabbitmq:$($rabbitMq.Image.Version)

# Run PostgreSQL server.
$postgres = $components | ? { $_.Image.Name -eq "postgres" }
& docker rm -f postgres
& docker run -d --name postgres --restart always --network axinom postgres:$($postgres.Image.Version)
