[CmdletBinding()]
param(
    # Version/tag of the image to install. Defaults to latest.
    [Parameter(Mandatory = $false)]
    [string]$version = "latest",

    [Parameter()]
    [switch]$useLocalImage
)

$ErrorActionPreference = "Stop"

$myDirectoryPath = $PSScriptRoot

if (!$myDirectoryPath) {
    $myDirectoryPath = "."
}

. (Join-Path $myDirectoryPath "./Functions.ps1")

$serviceInstallScriptPath = Join-Path $myDirectoryPath "Install-InfrastructureService.ps1"

if ($IsLinux) {
    & $serviceInstallScriptPath -containerName "deployment-agent" -imageNamespace "infrastructure" -imageName "deployment-agent-linux" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume /ComponentHost/Infrastructure/Config/deployment-agent/:/Config/ --volume /ComponentHost/Infrastructure/Data/deployment-agent/:/Data/ --volume /ComponentHost/Infrastructure/Config/http-gateway/:/Config-Gateway/ --volume /ComponentHost/Infrastructure/Logs/deployment-agent/:/Logs/ --volume /ComponentHost/Components/Data/:/Data-Containers/ --volume /ComponentHost/Components/Logs/:/Logs-Containers/ --volume /ComponentHost/Components/Config/:/Config-Containers/ --volume /ComponentHost/Infrastructure/Config/dashboard/:/Config-Dashboard/ --ip 172.31.250.200 --publish 6742:80 --publish 6743:443" -useLocalImage:$useLocalImage
}
else {
    $windowsVersion = ""

    if ((GetWindowsVersion) -eq "1803") {
        $windowsVersion = "-1803"
    }

    & $serviceInstallScriptPath -containerName "deployment-agent" -imageNamespace "infrastructure" -imageName "deployment-agent-windows$windowsVersion" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume C:\ComponentHost\Infrastructure\Config\deployment-agent\:C:\Config\ --volume C:\ComponentHost\Infrastructure\Data\deployment-agent\:C:\Data\ --volume C:\ComponentHost\Infrastructure\Config\http-gateway\:C:\Config-Gateway\ --volume C:\ComponentHost\Infrastructure\Logs\deployment-agent\:C:\Logs\ --volume C:\ComponentHost\Components\Data\:C:\Data-Containers\ --volume C:\ComponentHost\Components\Logs\:C:\Logs-Containers\ --volume C:\ComponentHost\Components\Config\:C:\Config-Containers\ --volume C:\ComponentHost\Infrastructure\Config\dashboard\:C:\Config-Dashboard\ --ip 172.31.250.200 --publish 6742:80 --publish 6743:443" -useLocalImage:$useLocalImage
}

if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to install the service!"
}

Write-Host "Success."