# PowerShell has no native mechanism to write UTF-8 files without BOM, but .NET has, so this method
# essentially wraps the .NET method that does it. Useful when creating configuration files for third party
# applications that fail to parse files with BOMs.
function Out-FileWithoutBOM($fileName)
{
	New-Item $fileName -ItemType File -Force  | Out-Null
	
	foreach ($content in $input) {
        [IO.File]::AppendAllText(($fileName | Resolve-Path), $content)
	}
}

function Get-DockerDaemonConfigFolder {
    if ($IsLinux) {
        return "/etc/docker/"
    } else {
        return Join-Path $env:ProgramData "docker\config"
    }
}