[CmdletBinding()]
param(
    # Version/tag of the image to install. Defaults to latest.
    [Parameter(Mandatory = $false)]
    [string]$version = "latest",

    [Parameter()]
    [switch]$useLocalImage
)

$ErrorActionPreference = "Stop"

$myDirectoryPath = $PSScriptRoot

if (!$myDirectoryPath) {
    $myDirectoryPath = "."
}

. (Join-Path $myDirectoryPath "./Functions.ps1")

$serviceInstallScriptPath = Join-Path $myDirectoryPath "Install-InfrastructureService.ps1"

$componentName = "docker-stats-exporter"

if ($IsLinux) {
	& $serviceInstallScriptPath -containerName $componentName -imageNamespace "prometheusnet" -imageName "docker_exporter" -imageVersion $version -runParameters "--volume /var/run/docker.sock:/var/run/docker.sock --ip 172.31.250.202 --publish 9183:9417" -useLocalImage:$useLocalImage
}
else {
    $windowsVersion = ""

    if ((GetWindowsVersion) -eq "1803") {
        $windowsVersion = "-1803"
    }

    & $serviceInstallScriptPath -containerName "$componentName" -imageNamespace "infrastructure" -imageName "$componentName-windows$windowsVersion" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume C:\ComponentHost\Infrastructure\Config\$componentName\:C:\Config\ --volume C:\ComponentHost\Infrastructure\Logs\$componentName\:C:\Logs\ --ip 172.31.250.202 --publish 9183:80" -useLocalImage:$useLocalImage
}

if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to install the service!"
}

Write-Host "Success."