[CmdletBinding()]
param(
    [Parameter(ParameterSetName = "http")]
    [switch]$http,
    [Parameter(ParameterSetName = "azureDns")]
    [switch]$azureDns,
    [Parameter(ParameterSetName = "route53")]
    [switch]$route53,

    [Parameter(ParameterSetName = "azureDns", Mandatory = $true)]
    [string]$subscriptionId,
    [Parameter(ParameterSetName = "azureDns", Mandatory = $true)]
    [string]$tenantId,
    [Parameter(ParameterSetName = "azureDns", Mandatory = $true)]
    [string]$applicationId,
    [Parameter(ParameterSetName = "azureDns", Mandatory = $true)]
    [string]$password,

    [Parameter(ParameterSetName="route53", Mandatory = $true)]
    [string]$accessKey,
    [Parameter(ParameterSetName="route53", Mandatory = $true)]
    [string]$secretKey,

    [Parameter(Mandatory = $false)]
    [string]$version = "latest",

    [Parameter()]
    [switch]$useLocalImage
)

$ErrorActionPreference = "Stop"

$myDirectoryPath = $PSScriptRoot

if (!$myDirectoryPath) {
    $myDirectoryPath = "."
}

. (Join-Path $myDirectoryPath "./Functions.ps1")

$configuration = @{}

if ($http) {
    $configuration.ChallengeType = "http"
} elseif ($azureDns) {
    $configuration.ChallengeType = "AzureDNS"
    $configuration.SubscriptionId = $subscriptionId
    $configuration.TenantId = $tenantId
    $configuration.ApplicationId = $applicationId
    $configuration.Password = $password
} elseif ($route53) {
    $configuration.ChallengeType = "Route53"
    $configuration.AccessKey = $accessKey
    $configuration.SecretKey = $secretKey
}

$configuration | ConvertTo-Json | Out-File -FilePath "/ComponentHost/Infrastructure/Config/acme/ACME.config"

$serviceInstallScriptPath = Join-Path $myDirectoryPath "Install-InfrastructureService.ps1"

if ($IsLinux) {
    & $serviceInstallScriptPath -containerName "acme" -imageNamespace "infrastructure" -imageName "acme-linux" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume /ComponentHost/Infrastructure/Config/acme/:/Config/ --volume /ComponentHost/Infrastructure/Data/http-gateway/:/Gateway/Data/ --volume /ComponentHost/Infrastructure/Config/http-gateway/:/Gateway/Config/ --volume /ComponentHost/Infrastructure/Data/acme/:/Data/ --volume /ComponentHost/Infrastructure/Logs/acme/:/Logs/ --ip 172.31.250.205" -useLocalImage:$useLocalImage
}
else {
    $windowsVersion = ""

    if ((GetWindowsVersion) -eq "1803") {
        $windowsVersion = "-1803"
    }

    & $serviceInstallScriptPath -containerName "acme" -imageNamespace "infrastructure" -imageName "acme-windows$windowsVersion" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume C:\ComponentHost\Infrastructure\Config\acme\:C:\Config\ --volume C:\ComponentHost\Infrastructure\Data\http-gateway\:C:\Gateway\Data\ --volume C:\ComponentHost\Infrastructure\Config\http-gateway\:C:\Gateway\Config\ --volume C:\ComponentHost\Infrastructure\Data\acme\:C:\Data\ --volume C:\ComponentHost\Infrastructure\Logs\acme\:C:\Logs\ --ip 172.31.250.205" -useLocalImage:$useLocalImage
}

if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to install the service!"
}

Write-Host "Success."