[CmdletBinding()]
param(
    # Version/tag of the image to install. Defaults to latest.
    [Parameter(Mandatory = $false)]
    [string]$version = "latest",

    [Parameter()]
    [switch]$useLocalImage
)

$ErrorActionPreference = "Stop"

$myDirectoryPath = $PSScriptRoot

if (!$myDirectoryPath) {
    $myDirectoryPath = "."
}

. (Join-Path $myDirectoryPath "./Functions.ps1")

$serviceInstallScriptPath = Join-Path $myDirectoryPath "Install-InfrastructureService.ps1"

$componentName = "http-gateway"

if ($IsLinux) {
    & $serviceInstallScriptPath -containerName "$componentName" -imageNamespace "infrastructure" -imageName "$componentName-linux" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume /ComponentHost/Infrastructure/Config/$componentName/:/Config/ --volume /ComponentHost/Infrastructure/Logs/$componentName/:/Logs/ --volume /ComponentHost/Infrastructure/Data/$componentName/:/Data/ --ip 172.31.250.201 --publish 80:80 --publish 82:82 --publish 83:83 --publish 443:443" -useLocalImage:$useLocalImage
}
else {
    $windowsVersion = ""

    if ((GetWindowsVersion) -eq "1803") {
        $windowsVersion = "-1803"
    }

    & $serviceInstallScriptPath -containerName "$componentName" -imageNamespace "infrastructure" -imageName "$componentName-windows$windowsVersion" -imageVersion $version -registryUrl "registry.axinom.com" -runParameters "--volume C:\ComponentHost\Infrastructure\Config\$componentName\:C:\Config\ --volume C:\ComponentHost\Infrastructure\Logs\$componentName\:C:\Logs\ --volume C:\ComponentHost\Infrastructure\Data\$componentName/:C:\Data\ --ip 172.31.250.201 --publish 80:80 --publish 82:82 --publish 83:83 --publish 443:443" -useLocalImage:$useLocalImage
}

if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to install the service!"
}

Write-Host "Success."