# Config.
$rabbitmq_user = "rabbituser"
$rabbitmq_pass = "rabbitpw"
$postgres_pass = "postgrespw"

# Create rabbitmq data folders.
mkdir -p /ComponentHost/CustomComponents/Data/rabbitmq
mkdir -p /ComponentHost/CustomComponents/Data/postgres
mkdir -p /ComponentHost/CustomComponents/Logs/rabbitmq

# Run RabbitMQ server.
& docker rm -f rabbitmq
& docker run -d -h vip-rabbitmq -v /ComponentHost/CustomComponents/Data/rabbitmq:/var/lib/rabbitmq -v /ComponentHost/CustomComponents/Logs/rabbitmq:/var/log/rabbitmq --name rabbitmq --restart always --ip 172.31.250.101 -p 5672:5672 -p 15672:15672 --network axinom -e RABBITMQ_DEFAULT_USER=$rabbitmq_user -e RABBITMQ_DEFAULT_PASS=$rabbitmq_pass rabbitmq:3.7.7-management

# Wait a little for RabbitMQ server to start.
Write-Host "Waiting 60 seconds for RabbitMQ server to start, before declaring base queues & exchanges..."
Start-Sleep -s 60

# Declare initial stuff inside rabbitmq.
& docker exec -it rabbitmq rabbitmqadmin --username=$rabbitmq_user --password=$rabbitmq_pass declare exchange name=cancellation type=fanout durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin --username=$rabbitmq_user --password=$rabbitmq_pass declare queue name=acquire durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin --username=$rabbitmq_user --password=$rabbitmq_pass declare queue name=encode durable=true auto_delete=false
& docker exec -it rabbitmq rabbitmqadmin --username=$rabbitmq_user --password=$rabbitmq_pass declare queue name=publish durable=true auto_delete=false

# Run PostgreSQL server.
& docker rm -f postgres
& docker run -d -h vip-postgres -v /ComponentHost/CustomComponents/Data/postgres:/var/lib/postgresql/data --name postgres --restart always --ip 172.31.250.102 -p 5432:5432 --network axinom -e POSTGRES_PASSWORD=$postgres_pass postgres:9.6

# Wait a little for PostgreSQL server to start.
Write-Host "Waiting 60 seconds for PostgreSQL server to start..."
Start-Sleep -s 60
